<?php

namespace Documentor\Api;

use Documentor\Exception\DocumentorApiException;
use Documentor\Exception\DocumentorHttpException;

/**
 * Call remote API commands
 * Class Call
 * @package Halk\Module\Document\Service
 */
class Call
{
    protected $_url;

    protected $_params = array();
    protected $_init = null;

    protected $notify;

    public function __construct($url)
    {
        $this->clearParams();
        $this->setUrl($url);
        $this->init();
    }

    public function setNotify($url)
    {
        $this->notify = $url;
    }

    public function setParam($key, $value)
    {
        $this->_params[$key] = $value;

        return $this;
    }

    public function getParams()
    {
        return $this->_params;
    }

    public function setUrl($url)
    {
        $this->_url = (string)$url;

        return $this;
    }

    public function getUrl()
    {
        return $this->_url;
    }

    public function clearParams()
    {
        $this->_params = array();

        return $this;
    }

    public function init()
    {
        $this->_init = curl_init();

        curl_setopt($this->_init, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($this->_init, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($this->_init, CURLOPT_SSL_VERIFYHOST, 2);
        curl_setopt($this->_init, CURLOPT_SSLVERSION, 1);
    }

    public function command($method)
    {
        return $this->setParam('command', $method);
    }

    public function execute()
    {
        $data = $this->buildRequest();
        $this->handleResponse($data);

        return $data->data;
    }

    public function buildRequest()
    {
        $request = http_build_query($this->getParams());

        if ( !is_resource($this->_init)) {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
            curl_setopt($ch, CURLOPT_SSLVERSION, 1);
        } else {
            $ch = $this->_init;
        }
        curl_setopt($ch, CURLOPT_URL, $this->getUrl());
        curl_setopt($ch, CURLOPT_POSTFIELDS, $request);

        $data = curl_exec($ch);
        $error = curl_error($ch);

        if (!empty($error)) {
            curl_close($ch);
            throw new DocumentorHttpException(sprintf('curl error: %s. url: %s.', $error, $this->getUrl()));
        }

        return json_decode($data);
    }

    protected function handleResponse($data)
    {
        if(!isset($data->success)){
            throw new DocumentorApiException('Ошибка разбора ответа');
        }

        if(!$data->success){
            if(count($data->errors) > 0) {
                throw new DocumentorApiException(array_shift($data->errors));
            }
        }
    }

    public function __destruct()
    {
        if (is_resource($this->_init)) {
            curl_close($this->_init);
        }
    }
}