<?php

namespace Documentor\Api;

/**
 * Simple Document API commands
 * Class Documentor
 * @package Halk\Module\Document\Service
 */
class Documentor
{
    protected $call;

    public function __construct($url)
    {
        $this->call = new Call($url);
    }

    public function setNotify($notify_url)
    {
        $this->call->setParam('notify_url', $notify_url);
    }

    public function init($html, $client_id)
    {
        return $this->call->command('init')
            ->setParam('html', $html)
            ->setParam('client_id', $client_id)
            ->execute();
    }

    public function status($token)
    {
        return $this->call->command('status')
            ->setParam('token', $token)
            ->execute();
    }

    public function delete($token)
    {
        return $this->call->command('delete')
            ->setParam('token', $token)
            ->execute();
    }

    public function reinit($token, $html)
    {
        return $this->call->command('reinit')
            ->setParam('html', $html)
            ->setParam('token', $token)
            ->execute();
    }
}