<?php
namespace Filanco;

use Adamlc\LetterCase\LetterCase;
use Filanco\BaseModel\Exception\UndefinedMethodException;
use Filanco\BaseModel\Exception\UndefinedPropertyException;
use Filanco\BaseModel\Exception\ValidationFailedException;

abstract class BaseModel
{
    protected $fields = [];

    /**
     * @return array название поля => описание
     */
    abstract protected function fields();

    public function __construct($data)
    {
        $fields = $this->fields();
        $fields_keys = array_keys($fields);
        foreach ($data as $key=>$value) {
            if (!in_array($key, $fields_keys)) {
                throw new UndefinedPropertyException(get_called_class(), $key);
            }
            $this->fields[$key] = $value;
        }
        $setted_keys = array_keys($this->fields);
        foreach ($fields as $key=>$value) {
            if(!in_array($key, $setted_keys)) {
                $this->fields[$key] = null;
            }
        }
    }

    protected function validators()
    {
        return [];
    }

    public function getValue($field, $enable_validation = true)
    {
        $fields = array_keys($this->fields());
        if (!in_array($field, $fields)) {
            throw new UndefinedPropertyException(get_called_class(), $field);
        }
        if ($enable_validation) {
            $this->validate($field, $this->fields[$field]);
        }
        return $this->fields[$field];
    }

    public function __call($name, $arguments)
    {
        if (strpos($name, 'get') === false) {
            throw new UndefinedMethodException(get_called_class(), $name);
        }
        $letter_case = new LetterCase();
        $key = $letter_case->snake(substr($name, 3));
        $enable_validation = (count($arguments) == 0)? true: !empty($arguments[0]);
        return $this->getValue($key, $enable_validation);
    }

    public function __isset($field)
    {
        $fields = $this->fields();
        $fields_keys = array_keys($fields);
        return in_array($field, $fields_keys);
    }

    public function getFieldName($field)
    {
        $fields = $this->fields();
        $fields_keys = array_keys($fields);
        if (!in_array($field, $fields_keys)) {
            throw new UndefinedPropertyException(get_called_class(), $field);
        }
        return $fields[$field];
    }

    public function validate($field, $value)
    {
        $validators = $this->validators();
        if (isset($validators[$field])) {
            if(!$validators[$field]($this->fields[$field])) {
                throw new ValidationFailedException($this, $field, $value);
            }
        }
    }
}