<?php
namespace Filanco\BaseModel\Exception;

use Exception;
use Filanco\BaseModel;

/**
 * Class ValidationFailedException
 * @package Filanco\BaseModel\Exception
 */
class ValidationFailedException extends Exception
{
    /** @var string */
    public $key;

    /** @var string */
    public $name;

    /** @var string */
    public $value;

    /**
     * ValidationFailedException constructor.
     * @param BaseModel $model
     * @param string $key
     * @param mixed $value
     * @param int $code
     * @param Exception $previous
     */
    public function __construct(BaseModel $model, $key, $value, $code = 0, Exception $previous = null)
    {
        $this->key = $key;
        $this->name = $model->getFieldName($key);
        $this->value = $value;
        $message = 'Значениe ' . $value . ' заполнено не верно для поля ' . $this->name . '!';
        parent::__construct($message, $code, $previous);
    }
}
