<?php
namespace Filanco\BaseModel\Exception;

use Exception;

/**
 * Class UndefinedMethodException
 * @package Filanco\BaseModel\Exception
 */
class UndefinedMethodException extends Exception
{
    /**
     * UndefinedMethodException constructor.
     * @param string $class_name
     * @param int $method_name
     * @param int $code
     * @param Exception $previous
     */
    public function __construct($class_name, $method_name, $code = 0, Exception $previous = null)
    {
        $message = 'В классе ' . $class_name . ' не найдено метода ' . $method_name . '!';
        parent::__construct($message, $code, $previous);
    }
}
