<?php
namespace Filanco\Certificate;

use Filanco\Certificate\Exception\ResellerApiNotFoundException;

/**
 * Class ResellerApiFactory
 * @package Filanco\Certificate
 */
class ResellerApiFactory
{
    /**
     * @param ResellerInterface $reseller
     * @param ResellerApiLogInterface $logger
     * @return ResellerApiAbstract
     * @throws ResellerApiNotFoundException
     */
    public static function create(ResellerInterface $reseller, ResellerApiLogInterface $logger = null)
    {
        /**
         * @var $class_name ResellerApiAbstract
         */
        $class_name = __NAMESPACE__ . '\\Api\\' . ucfirst($reseller->getSystemName());
        if (!class_exists($class_name)) {
            throw new ResellerApiNotFoundException($class_name);
        }

        return new $class_name($reseller, $logger);
    }
}
