<?php
use Filanco\BaseModel;
use Filanco\Certificate\ResellerApiFactory;
use Filanco\Certificate\ResellerInterface;
use Filanco\Certificate\ResellerApiLogInterface;

require_once __DIR__ . '/../vendor/autoload.php';

class Reseller extends BaseModel implements ResellerInterface
{
    protected function fields()
    {
        return [
            'name' => 'Название реселлера',
            'uri' => 'Базовый путь для запросов',
            'login' => 'Логин',
            'password' => 'Пароль',
            'port' => 'Порт',
            'system_name' => 'Системное имя',
            'content_type' => 'Формат запросов',
        ];
    }

    protected function validators()
    {
        return [
            'uri' => function ($value) {
                return !empty($value);
            },
            'login' => function ($value) {
                return !empty($value);
            },
            'password' => function ($value) {
                return !empty($value);
            },
            'port' => function ($value) {
                return !empty($value);
            },
            'system_name' => function ($value) {
                return !empty($value);
            },
            'content_type' => function ($value) {
                return !empty($value);
            },
        ];
    }

    public function getName()
    {
        return $this->getValue('name');
    }

    public function getUri()
    {
        return $this->getValue('uri');
    }

    public function getLogin()
    {
        return $this->getValue('login');
    }

    public function getPassword()
    {
        return $this->getValue('password');
    }

    public function getPort()
    {
        return $this->getValue('port');
    }

    public function getSystemName()
    {
        return $this->getValue('system_name');
    }

    public function getContentType()
    {
        return $this->getValue('content_type');
    }
}
class Logger implements ResellerApiLogInterface
{
    protected $log = [];

    public function setWho($reseller_name)
    {
        $this->log[] = $reseller_name;
    }

    public function setRequest($request)
    {
        $this->log[] = $request;
    }

    public function setResponse($response)
    {
        $this->log[] = $response;
    }

    public function setStamp($stamp)
    {
        $this->log[] = $stamp;
    }

    public function save()
    {
        echo implode("\t", $this->log);
    }
}

$resellers = json_decode(file_get_contents(__DIR__ . '/reseller.json'), true);

$reseller = new Reseller($resellers['leader']);

$reseller_api = ResellerApiFactory::create($reseller, new Logger());

var_dump($reseller_api->getCatalog());