<?php
namespace Filanco\Certificate\Exception;

use Exception;
use Filanco\Certificate\Model\Certificate;

class CertificateStatusUnknownException extends CertificateException
{
    /** @var Certificate */
    protected $certificate;

    /**
     * CertificateStatusUnknownException constructor.
     * @param Certificate $certificate
     * @param string $status
     * @param array $available_statuses
     * @param Exception|null $previous
     */
    public function __construct(Certificate $certificate, $status, array $available_statuses, Exception $previous = null)
    {
        $message = 'Не известный статус сертификата: ' . $status . PHP_EOL . 'Известные статусы: ' . json_encode($available_statuses);
        parent::__construct($certificate, $message, $previous);
    }
}
