<?php
namespace Filanco\Certificate\Model;

use Filanco\BaseModel;

/**
 * Class Anketa
 * @package Filanco\Certificate\Model
 *
 * @method string getCountryCode() Буквенный код страны
 * @method string getRegionName() Название региона
 * @method string getCityName() Название города
 * @method string getOrganizationName() Название организации
 * @method string getOrganizationalUnit() Тип собственности организации
 * @method string getZipCode() Почтовый индекс
 * @method array getAddress() Адресная строка
 * @method array getAdditionalDomainApproverEmails() Адреса электронных почт на которые прийдут проверочные сообщения для дополнительных доменов
 * @method string getApproverEmail() Адрес электронной почты на который прийдет проверочное сообщение
 * @method string getFirstName() Имя администратора
 * @method string getLastName() Фамилия администратора
 * @method string getPhone() Контактный телефон администратора
 * @method string getFax() Факс администратора
 * @method string getEmail() Email администратора
 */
class Anketa extends BaseModel
{
    protected function fields()
    {
        return [
            'country_code' => 'Буквенный код страны',
            'region_name' => 'Название региона',
            'city_name' => 'Название города',
            'organization_name' => 'Название организации',
            'organizational_unit' => 'Тип собственности организации',
            'zip_code' => 'Почтовый индекс',
            'address' => 'Адресная строка',
            'additional_domain_approver_emails' => 'Адреса электронных почт на которые прийдут проверочные сообщения для дополнительных доменов',
            'approver_email' => 'Адрес электронной почты на который прийдет проверочное сообщение',
            'first_name' => 'Имя администратора',
            'last_name' => 'Фамилия администратора',
            'phone' => 'Контактный телефон администратора',
            'fax' => 'Факс администратора',
            'email' => 'Email администратора'
        ];
    }
}