<?php
namespace Filanco\Certificate\Exception;

use Exception;
use Filanco\Certificate\Model\Certificate;

class CertificateException extends Exception
{
    /** @var Certificate */
    protected $certificate;

    public function __construct(Certificate $certificate, $message, Exception $previous = null)
    {
        $this->certificate = $certificate;
        $message = <<<EOL
Идентификатор сертификата: {$certificate->getId()}
Произошла ошибка: {$message}
EOL;
        parent::__construct($message, 0, $previous);
    }
}
