<?php

namespace Filanco\Cms\Widgets;

use Arrilot\Widgets\AbstractWidget;
use Filanco\Cms\Facades\Cms;

class UserDimmer extends AbstractWidget
{
    /**
     * The configuration array.
     *
     * @var array
     */
    protected $config = [];

    /**
     * Treat this method as a controller action.
     * Return view() or other content to display.
     */
    public function run()
    {
        $count = Cms::model('User')->count();
        $string = $count == 1 ? 'user' : 'users';

        return view('Cms::dimmer', array_merge($this->config, [
            'icon'   => 'Cms-group',
            'title'  => "{$count} {$string}",
            'text'   => "Сейчас в базе {$count} пользователь",
            'button' => [
                'text' => 'Все пользователи',
                'link' => route('Cms.users.index'),
            ],
            'image' => Cms_asset('images/widget-backgrounds/02.png'),
        ]));
    }
}
