<?php

namespace Filanco\Cms\Tests;

class RouteTest extends TestCase
{
    protected $withDummy = true;

    public function setUp()
    {
        parent::setUp();

        $this->install();
    }

    /**
     * A basic functional test example.
     *
     * @return void
     */
    public function testGetRoutes()
    {
        $this->disableExceptionHandling();

        $this->visit(route('Cms.login'));
        $this->type('admin@admin.com', 'email');
        $this->type('password', 'password');
        $this->press('Login');

        $urls = [
            route('Cms.dashboard'),
            route('Cms.media.index'),
            route('Cms.settings.index'),
            route('Cms.roles.index'),
            route('Cms.roles.create'),
            route('Cms.roles.show', ['role' => 1]),
            route('Cms.roles.edit', ['role' => 1]),
            route('Cms.users.index'),
            route('Cms.users.create'),
            route('Cms.users.show', ['user' => 1]),
            route('Cms.users.edit', ['user' => 1]),
            route('Cms.posts.index'),
            route('Cms.posts.create'),
            route('Cms.posts.show', ['post' => 1]),
            route('Cms.posts.edit', ['post' => 1]),
            route('Cms.pages.index'),
            route('Cms.pages.create'),
            route('Cms.pages.show', ['page' => 1]),
            route('Cms.pages.edit', ['page' => 1]),
            route('Cms.categories.index'),
            route('Cms.categories.create'),
            route('Cms.categories.show', ['category' => 1]),
            route('Cms.categories.edit', ['category' => 1]),
            route('Cms.menus.index'),
            route('Cms.menus.create'),
            route('Cms.menus.show', ['menu' => 1]),
            route('Cms.menus.edit', ['menu' => 1]),
            route('Cms.database.index'),
            route('Cms.database.edit_bread', ['table' => 'categories']),
            route('Cms.database.edit', ['table' => 'categories']),
            route('Cms.database.create'),
        ];

        foreach ($urls as $url) {
            $response = $this->call('GET', $url);
            $this->assertEquals(200, $response->status(), $url.' did not return a 200');
        }
    }
}
