<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFcms.dataTypesTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('fcms.data_types', function(Blueprint $table)
		{
			$table->integer('id', true);
			$table->string('name')->unique('data_types_name_unique');
			$table->string('slug')->unique('data_types_slug_unique');
			$table->string('display_name_singular');
			$table->string('display_name_plural');
			$table->string('icon')->nullable();
			$table->string('model_name')->nullable();
			$table->string('description')->nullable();
			$table->boolean('generate_permissions')->default(0);
			$table->timestamps();
			$table->smallInteger('server_side')->default('0::smallint');
			$table->string('controller')->nullable();
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('fcms.data_types');
	}

}
