<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFcms.menuItemsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('fcms.menu_items', function(Blueprint $table)
		{
			$table->integer('id', true);
			$table->integer('menu_id')->nullable();
			$table->string('title');
			$table->string('url');
			$table->string('target')->default('_self');
			$table->string('icon_class')->nullable();
			$table->string('color')->nullable();
			$table->integer('parent_id')->nullable();
			$table->integer('order');
			$table->timestamps();
			$table->string('route')->nullable();
			$table->text('parameters')->nullable();
			$table->string('command')->nullable();
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('fcms.menu_items');
	}

}
