<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFcms.pagesTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('fcms.pages', function(Blueprint $table)
		{
			$table->integer('id', true);
			$table->integer('author_id');
			$table->string('title');
			$table->text('excerpt')->nullable();
			$table->text('body')->nullable();
			$table->string('image')->nullable();
			$table->string('slug')->nullable()->unique('pages_slug_unique');
			$table->text('meta_description')->nullable();
			$table->text('meta_keywords')->nullable();
			$table->string('status')->default('INACTIVE');
			$table->timestamps();
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('fcms.pages');
	}

}
