<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFcms.postsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('fcms.posts', function(Blueprint $table)
		{
			$table->integer('id', true);
			$table->integer('author_id');
			$table->integer('category_id')->nullable();
			$table->string('title');
			$table->string('seo_title')->nullable();
			$table->text('excerpt');
			$table->text('body');
			$table->string('image')->nullable();
			$table->string('slug')->unique('posts_slug_unique');
			$table->text('meta_description');
			$table->text('meta_keywords');
			$table->string('status')->default('DRAFT');
			$table->boolean('featured')->default(0);
			$table->timestamps();
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('fcms.posts');
	}

}
