<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFcms.settingsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('fcms.settings', function(Blueprint $table)
		{
			$table->integer('id', true);
			$table->string('key')->unique('settings_key_unique');
			$table->string('display_name');
			$table->text('value');
			$table->text('details')->nullable();
			$table->string('type');
			$table->integer('order')->default(1);
			$table->string('command')->nullable();
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('fcms.settings');
	}

}
