<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFcms.translationsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('fcms.translations', function(Blueprint $table)
		{
			$table->integer('id', true);
			$table->string('table_name');
			$table->string('column_name');
			$table->integer('foreign_key');
			$table->string('locale');
			$table->text('value');
			$table->timestamps();
			$table->unique(['table_name','column_name','foreign_key','locale'], 'translations_table_name_column_name_foreign_key_locale_unique');
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('fcms.translations');
	}

}
