<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class AddForeignKeysToFcms.categoriesTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('fcms.categories', function(Blueprint $table)
		{
			$table->foreign('parent_id', 'categories_parent_id_foreign')->references('id')->on('categories')->onUpdate('CASCADE')->onDelete('SET NULL');
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('fcms.categories', function(Blueprint $table)
		{
			$table->dropForeign('categories_parent_id_foreign');
		});
	}

}
