<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class AddForeignKeysToFcms.menuItemsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('fcms.menu_items', function(Blueprint $table)
		{
			$table->foreign('menu_id', 'menu_items_menu_id_foreign')->references('id')->on('menus')->onUpdate('RESTRICT')->onDelete('CASCADE');
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('fcms.menu_items', function(Blueprint $table)
		{
			$table->dropForeign('menu_items_menu_id_foreign');
		});
	}

}
