<?php

namespace Filanco\Cms\Http\Controllers;

use Exception;
use Illuminate\Http\Request;
use Filanco\Cms\Facades\Cms;
use Filanco\Cms\Models\Sitemap;
use Filanco\Cms\Traits\AlertsMessages;

class CmsSitemapController extends Controller
{



    public function index()
    {
        $map = new Sitemap();

        return view('Cms::sitemap.index', ['dateSiteMap' => $map->getFileCreate()]);
    }


    public function create()
    {
        $responsne = (new Sitemap())->create();

        if ($responsne) {
            return redirect()->route('Cms.sitemap.index')->with($this->alertSuccess("Карта обновлена"));
        } else {
            return redirect()->route('Cms.sitemap.index')->with($this->alertException($responsne, 'Saving Failed'));
        }
    }


}
