<?php

namespace Filanco\Cms\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Filanco\Cms\Facades\Cms;

class CmsAdminMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Closure                 $next
     *
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (!Auth::guest()) {
            $user = Cms::model('User')->find(Auth::id());

            return $user->hasPermission('browse_admin') ? $next($request) : redirect('/');
        }

        return redirect(route('Cms.login'));
    }
}
