<ol class="dd-list">

@foreach ($items->sortBy('order') as $item)

    <li class="dd-item" data-id="{{ $item->id }}">
        <div class="pull-right item_actions">
            <div class="btn-sm btn-danger pull-right delete" data-id="{{ $item->id }}">
                <i class="Cms-trash"></i> Delete
            </div>
            <div class="btn-sm btn-primary pull-right edit"
                data-id="{{ $item->id }}"
                data-title="{{ $item->title }}"
                data-url="{{ $item->url }}"
                data-target="{{ $item->target }}"
                data-icon_class="{{ $item->icon_class }}"
                data-color="{{ $item->color }}"
                data-route="{{ $item->route }}"
                data-parameters="{{ htmlspecialchars(json_encode($item->parameters)) }}"
            >
                <i class="Cms-edit"></i> Edit
            </div>
        </div>
        <div class="dd-handle">
            @if($options->isModelTranslatable)
                @include('Cms::multilingual.input-hidden-menu', [
                    'isModelTranslatable' => true,
                    '_field_name'         => 'title'.$item->id,
                    '_field_trans'        => htmlspecialchars(json_encode($item->getTranslationsOf('title')))
                ])
            @endif
            <span>{{ $item->title }}</span> <small class="url">{{ $item->link() }}</small>
        </div>
        @if(!$item->children->isEmpty())
            @include('Cms::menu.admin', ['items' => $item->children])
        @endif
    </li>

@endforeach

</ol>