<?php

namespace Filanco\Cms\Widgets;

use Arrilot\Widgets\AbstractWidget;
use Filanco\Cms\Facades\Cms;

class PageDimmer extends AbstractWidget
{
    /**
     * The configuration array.
     *
     * @var array
     */
    protected $config = [];

    /**
     * Treat this method as a controller action.
     * Return view() or other content to display.
     */
    public function run()
    {
        $count = Cms::model('Page')->count();
        $string = $count == 1 ? 'page' : 'pages';

        return view('Cms::dimmer', array_merge($this->config, [
            'icon'   => 'Cms-group',
            'title'  => "{$count} {$string}",
            'text'   => "Сейчас в базе {$count} страниц",
            'button' => [
                'text' => 'Все страницы',
                'link' => route('Cms.pages.index'),
            ],
            'image' => Cms_asset('images/widget-backgrounds/03.png'),
        ]));
    }
}
