<?php
use Filanco\Cms\Models\Page;
use Filanco\Cms\Models\Post;
use Filanco\Cms\Models\DataType;

/*
|--------------------------------------------------------------------------
| Cms Routes
|--------------------------------------------------------------------------
|
| This file is where you may override any of the routes that are included
| with Cms.
|
*/

Route::group(['prefix' => 'admin'], function () {
    Route::group(['as' => 'Cms.'], function () {
        event('Cms.routing', app('router'));

        $namespacePrefix = '\\'.config('Cms.controllers.namespace').'\\';

        Route::get('login', ['uses' => $namespacePrefix.'CmsAuthController@login', 'as' => 'login']);
        Route::post('login', ['uses' => $namespacePrefix.'CmsAuthController@postLogin', 'as' => 'postlogin']);

        Route::group(['middleware' => 'admin.user'], function () use ($namespacePrefix) {
            event('Cms.admin.routing', app('router'));

            // Main Admin and Logout Route
            Route::get('/', ['uses' => $namespacePrefix.'CmsController@index', 'as' => 'dashboard']);
            Route::post('logout', ['uses' => $namespacePrefix.'CmsController@logout', 'as' => 'logout']);
            Route::post('upload', ['uses' => $namespacePrefix.'CmsController@upload', 'as' => 'upload']);

            Route::get('profile', ['uses' => $namespacePrefix.'CmsController@profile', 'as' => 'profile']);

            try {
                foreach (DataType::all() as $dataType) {


                    $breadController = $dataType->controller
                        ? $dataType->controller
                        : $namespacePrefix.'CmsBreadController';
                    Route::resource($dataType->slug, $breadController);
                }
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException("Custom routes hasn't been configured because: ".$e->getMessage(), 1);
            } catch (\Exception $e) {
                // do nothing, might just be because table not yet migrated.
            }

            // Role Routes
            Route::resource('roles', $namespacePrefix.'CmsRoleController');

            // Menu Routes
            Route::group([
                'as'     => 'menus.',
                'prefix' => 'menus/{menu}',
            ], function () use ($namespacePrefix) {
                Route::get('builder', ['uses' => $namespacePrefix.'CmsMenuController@builder', 'as' => 'builder']);
                Route::post('order', ['uses' => $namespacePrefix.'CmsMenuController@order_item', 'as' => 'order']);

                Route::group([
                    'as'     => 'item.',
                    'prefix' => 'item',
                ], function () use ($namespacePrefix) {
                    Route::delete('{id}', ['uses' => $namespacePrefix.'CmsMenuController@delete_menu', 'as' => 'destroy']);
                    Route::post('/', ['uses' => $namespacePrefix.'CmsMenuController@add_item', 'as' => 'add']);
                    Route::put('/', ['uses' => $namespacePrefix.'CmsMenuController@update_item', 'as' => 'update']);
                });
            });

            // Settings
            Route::group([
                'as'     => 'settings.',
                'prefix' => 'settings',
            ], function () use ($namespacePrefix) {
                Route::get('/', ['uses' => $namespacePrefix.'CmsSettingsController@index', 'as' => 'index']);
                Route::post('/', ['uses' => $namespacePrefix.'CmsSettingsController@store', 'as' => 'store']);
                Route::put('/', ['uses' => $namespacePrefix.'CmsSettingsController@update', 'as' => 'update']);
                Route::delete('{id}', ['uses' => $namespacePrefix.'CmsSettingsController@delete', 'as' => 'delete']);
                Route::get('{id}/move_up', ['uses' => $namespacePrefix.'CmsSettingsController@move_up', 'as' => 'move_up']);
                Route::get('{id}/move_down', ['uses' => $namespacePrefix.'CmsSettingsController@move_down', 'as' => 'move_down']);
                Route::get('{id}/delete_value', ['uses' => $namespacePrefix.'CmsSettingsController@delete_value', 'as' => 'delete_value']);
            });



            // Sitemap
            Route::group([
                'as'     => 'sitemap.',
                'prefix' => 'sitemap',
            ], function () use ($namespacePrefix) {
                Route::get('/', ['uses' => $namespacePrefix.'CmsSitemapController@index', 'as' => 'index']);
                Route::get('/create', ['uses' => $namespacePrefix.'CmsSitemapController@create', 'as' => 'create']);

            });





            // Admin Media
            Route::group([
                'as'     => 'media.',
                'prefix' => 'media',
            ], function () use ($namespacePrefix) {
                Route::get('/', ['uses' => $namespacePrefix.'CmsMediaController@index', 'as' => 'index']);
                Route::post('files', ['uses' => $namespacePrefix.'CmsMediaController@files', 'as' => 'files']);
                Route::post('new_folder', ['uses' => $namespacePrefix.'CmsMediaController@new_folder', 'as' => 'new_folder']);
                Route::post('delete_file_folder', ['uses' => $namespacePrefix.'CmsMediaController@delete_file_folder', 'as' => 'delete_file_folder']);
                Route::post('directories', ['uses' => $namespacePrefix.'CmsMediaController@get_all_dirs', 'as' => 'get_all_dirs']);
                Route::post('move_file', ['uses' => $namespacePrefix.'CmsMediaController@move_file', 'as' => 'move_file']);
                Route::post('rename_file', ['uses' => $namespacePrefix.'CmsMediaController@rename_file', 'as' => 'rename_file']);
                Route::post('upload', ['uses' => $namespacePrefix.'CmsMediaController@upload', 'as' => 'upload']);
                Route::post('remove', ['uses' => $namespacePrefix.'CmsMediaController@remove', 'as' => 'remove']);
            });

            // Database Routes
            Route::group([
                'as'     => 'database.',
                'prefix' => 'database',
            ], function () use ($namespacePrefix) {
                Route::get('bread/{table}/create', ['uses' => $namespacePrefix.'CmsDatabaseController@addBread', 'as' => 'create_bread']);
                Route::post('bread/', ['uses' => $namespacePrefix.'CmsDatabaseController@storeBread', 'as' => 'store_bread']);
                Route::get('bread/{table}/edit', ['uses' => $namespacePrefix.'CmsDatabaseController@addEditBread', 'as' => 'edit_bread']);
                Route::put('bread/{id}', ['uses' => $namespacePrefix.'CmsDatabaseController@updateBread', 'as' => 'update_bread']);
                Route::delete('bread/{id}', ['uses' => $namespacePrefix.'CmsDatabaseController@deleteBread', 'as' => 'delete_bread']);
            });

            Route::resource('database', $namespacePrefix.'CmsDatabaseController');
        });
    });

});


Route::any( 'post/{category}/{post}', function ( $category,$post_slug ) {

    $page = Post::where('status', 'PUBLISHED')
        ->where('slug', $post_slug) ->first();

    if(isset($page)) {
        // call the content controller's method here.
        return view('post.view', [
            'page' => $page
        ]);
    }
    else {
        abort('404');
    }

} )->where('category', '[A-Za-z0-9]+');




//Роут для страничек
Route::any( '{catchall}', function ( $url ) {
    $page = Page::where('status', 'ACTIVE')
        ->where('slug', $url) ->first();

    if(isset($page)) {
        // call the content controller's method here.

        return view('frontend.page', [
            'page' => $page
        ]);
    }
    else {
        abort('404');
    }

} )->where('catchall', '(.*)');