<?php

namespace Filanco\Cms\Widgets;

use Arrilot\Widgets\AbstractWidget;
use Filanco\Cms\Facades\Cms;

class PostDimmer extends AbstractWidget
{
    /**
     * The configuration array.
     *
     * @var array
     */
    protected $config = [];

    /**
     * Treat this method as a controller action.
     * Return view() or other content to display.
     */
    public function run()
    {
        $count = Cms::model('Post')->count();
        $string = $count == 1 ? 'post' : 'posts';

        return view('Cms::dimmer', array_merge($this->config, [
            'icon'   => 'Cms-group',
            'title'  => "{$count} {$string}",
            'text'   => "Сейчас в баз {$count} пост",
            'button' => [
                'text' => 'Все посты',
                'link' => route('Cms.posts.index'),
            ],
            'image' => Cms_asset('images/widget-backgrounds/03.png'),
        ]));
    }
}
