<?php

declare(strict_types=1);

namespace Filanco\DadataBundle\DependencyInjection;

use Exception;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

class FilancoDadataExtension extends Extension
{
    /**
     * {@inheritdoc}
     * @throws Exception
     */
    public function load(array $configs, ContainerBuilder $container): void
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new YamlFileLoader($container, new FileLocator(__DIR__.'/../Resources/config'));
        $loader->load('services.yaml');

        $container->setParameter('dadata.token', $config['token']);
        $container->setParameter('dadata.secret', $config['secret']);
        $container->setParameter('dadata.base_general_url', $config['base_general_url']);
        $container->setParameter('dadata.base_cleaner_url', $config['base_cleaner_url']);
        $container->setParameter('dadata.base_suggestions_url', $config['base_suggestions_url']);
    }
}
