<?php

declare(strict_types=1);

namespace Filanco\DadataBundle\Tests;

use Symfony\Component\Config\Loader\LoaderInterface;
use Symfony\Component\HttpKernel\Kernel;
use Filanco\DadataBundle\FilancoDadataBundle;

if (version_compare(Kernel::VERSION, '6.0', '<')) {
    class TestingKernel extends Kernel
    {
        /**
         * @return iterable<mixed, Symfony\Component\HttpKernel\Bundle\BundleInterface>
         */
        public function registerBundles()
        {
            return [
                new FilancoDadataBundle(),
            ];
        }

        /**
         * {@inheritdoc}
         */
        public function registerContainerConfiguration(LoaderInterface $loader)
        {
            $loader->load(__DIR__.'/DependencyInjection/config.yaml');
        }
    }
} else {
    class TestingKernel extends Kernel
    {
        public function registerBundles(): iterable
        {
            return [
                new FilancoDadataBundle(),
            ];
        }

        /**
         * {@inheritdoc}
         */
        public function registerContainerConfiguration(LoaderInterface $loader)
        {
            $loader->load(__DIR__.'/DependencyInjection/config.yaml');
        }
    }
}
