<?php

namespace Documentor\Api;

/**
 * Simple Document API commands
 * Class Documentor
 * @package Halk\Module\Document\Service
 */
class Documentor
{
    protected $call;

    public function __construct($url)
    {
        $this->call = new Call($url);
    }

    public function setNotify($notify_url)
    {
        $this->call->setParam('notify_url', $notify_url);
    }

    /**
     * Portrait or Landscape
     * @param string $orientation
     */
    public function setOrientation($orientation = 'Portrait')
    {
        $this->call->setParam('orientation', $orientation);
    }

    /**
     * Default 10mm
     * @param int $margin_top
     */
    public function setMarginTop($margin_top = 10)
    {
        $this->call->setParam('margin-top', sprintf('%dmm', $margin_top));
    }

    /**
     * @param int $margin_bottom
     */
    public function setMarginBottom($margin_bottom = 10)
    {
        $this->call->setParam('margin-bottom', sprintf('%dmm', $margin_bottom));
    }

    /**
     * Default 10mm
     * @param int $margin_left
     */
    public function setMarginLeft($margin_left = 10)
    {
        $this->call->setParam('margin-left', sprintf('%dmm', $margin_left));
    }

    /**
     * Default 10mm
     * @param int $margin_right
     */
    public function setMarginRight($margin_right = 10)
    {
        $this->call->setParam('margin-right', sprintf('%dmm', $margin_right));
    }

    public function init($html, $client_id)
    {
        return $this->call->command('init')
            ->setParam('html', $html)
            ->setParam('client_id', $client_id)
            ->execute();
    }

    public function status($token)
    {
        return $this->call
            ->clearParams()
            ->command('status')
            ->setParam('token', $token)
            ->execute();
    }

    public function delete($token)
    {
        return $this->call
            ->clearParams()
            ->command('delete')
            ->setParam('token', $token)
            ->execute();
    }

    public function reinit($token, $html)
    {
        return $this->call->command('reinit')
            ->setParam('html', $html)
            ->setParam('token', $token)
            ->execute();
    }

    public function merge(Array $items, $to)
    {
        return $this->call->command('merge')
            ->setParam('items', join(',', $items))
            ->file($to);
    }
}
