<?php
namespace Filanco\Domain\Model;

/**
 * Class Order
 * @package Filanco\Domain\Model
 *
 * @method string getId() Идентификатор задания
 * @method string getStatus() Статус задания
 */
class Order extends BaseModel
{
    const
        STATUS_PENDING = 'pending',
        STATUS_ERROR = 'error',
        STATUS_RUNNING = 'running',
        STATUS_SUCCESS = 'success';

    public function getStatuses()
    {
        return [
            static::STATUS_PENDING => 'В ожидании обработки',
            static::STATUS_ERROR => 'Ошибка при обработке',
            static::STATUS_RUNNING => 'В процеесе обработки',
            static::STATUS_SUCCESS => 'Успешно обработано',
        ];
    }

    protected function fields()
    {
        return [
            'id' => 'Идентификатор заказа',
            'status' => 'Статус заказа'
        ];
    }

    protected function validators()
    {
        return [
            'id' => function($value){
                return !empty($value);
            },
            'status' => function($value){
                return in_array($value, array_keys($this->getStatuses()));
            }
        ];
    }
}
