<?php
namespace Filanco\Domain;
use Filanco\Domain\Model\Client;

/**
 * Interface RegistrarApiInterface
 * @package Filanco\Domain
 */
interface RegistrarApiInterface
{
    /**
     * Запрос на регистрацию домена
     * @param Client $client
     * @param string $domain
     * @param array $name_servers
     * @param int $years
     * @return mixed
     */
    public function registerDomain(Client $client, $domain, array $name_servers, $years = 1);

    /**
     * Запрос на продление домена
     * @param string $domain
     * @param int $years
     * @return mixed
     */
    public function prolongDomain($domain, $years = 1);

    /**
     * Запрос на переделегирование домена
     * @param string $domain
     * @param array $name_servers
     * @return mixed
     */
    public function redeligateDomain($domain, array $name_servers);

    /**
     * @param string $domain
     * @return mixed информация по домену
     */
    public function checkDomain($domain);

    /**
     * @param string $domain
     * @return bool доступен ли домен для регистрации
     */
    public function checkAvailability($domain);

    /**
     * @param string $domain
     * @return bool находится ли домен на нашем аккаунте
     */
    public function checkIfOurs($domain);

    /**
     * @param string $domain
     * @return string Дата окончания домена
     */
    public function getExpirationDate($domain);

    /**
     * @return array Список всех доменов
     */
    public function getDomainList();

    /**
     * @return array Список доменов доступных для продления
     */
    public function getExpiredDomainList();
}
