<?php
namespace Filanco\Domain;

use Filanco\Domain\Model\Client;
use Filanco\Domain\Model\Domain;

/**
 * Interface PremiumDomainInterface
 * @package Filanco\Domain
 * @todo ProlongPremiumDomain
 */
interface PremiumDomainInterface
{
    /**
     * Запрос на регистрацию премиального домена
     * @param Client $client
     * @param string $domain
     * @param array $name_servers
     * @param float $known_price предполагаемая стоимость домена
     * @param int $years
     * @return mixed
     */
    public function registerPremiumDomain(Client $client, $domain, array $name_servers, $known_price, $years = 1);

    /**
     * @param array $domains
     * @return Domain[] информация по премиальным доменам
     */
    public function getPremiumDomainsInfo(array $domains);
}