<?php
require_once __DIR__ . '/init.php';

use Filanco\Domain\RegistrarApiFactory;


/**
 * registrar.json format file
 *
      {
        "domenus": {
            "name": "domenus",
            "login": "***",
            "password": "***",
            "port": "443",
            "uri": "***u",
            "type": "xml"
        },
        "enom": {
            "name": "enom",
            "login": "***",
            "password": "***",
            "port": "***",
            "uri": "***",
            "type": "xml"
        }
     }
 *
 */
$registrar_list = json_decode(file_get_contents(__DIR__ . '/registrar.json'), TRUE);


$registrar = new Registrar($registrar_list['regru']);
$logger = new Logger();
$registrar_api = RegistrarApiFactory::factory($registrar, $logger);


$domains = ['мама-папа.рф', 'mama-papa.ru', 'tytbilia.su']; // domenus
$domains = ['мама-папа.com', 'mama-papa.com', 'tikvatyt.com', '534534534.net']; //enom
$domains = ['мама-папа.spb.su', 'mama-papa.msk.su', 'tikvatyt.net.ru', '534534534.bir.ru', 'testitk.org.ru']; // nic
$domains = ['мама-папа.москва', 'mama-papa.pro', 'mama-papa12.pro', 'tikvatyt.in', '534534534.at', 'testitk.am']; // regru
$result = $registrar_api->checkAvailabilityList($domains);

var_dump($result);

die;