<?php
require_once __DIR__ . '/init.php';

use Filanco\Domain\PremiumDomainInterface;
use Filanco\Domain\RegistrarApiFactory;


/**
 * registrar.json format file
 *
{
"domenus": {
"name": "domenus",
"login": "***",
"password": "***",
"port": "443",
"uri": "***u",
"type": "xml"
},
"enom": {
"name": "enom",
"login": "***",
"password": "***",
"port": "***",
"uri": "***",
"type": "xml"
}
}
 *
 */
$registrar_list = json_decode(file_get_contents(__DIR__ . '/registrar.json'), TRUE);

$registrar = new Registrar($registrar_list['domenus']); // имя регистратора

$logger = new Logger();
$registrar_api = RegistrarApiFactory::factory($registrar, $logger);
if ($registrar_api instanceof PremiumDomainInterface) {
    $info = $registrar_api->checkAvailabilityList([
        'sport.studio',
        'web.studio'
    ]);
    echo array_shift($info)->getCost()->getRegister() . PHP_EOL;
}


