<?php
namespace Filanco\Domain\Exception;

use Exception;

/**
 * Class OrderStatusUnknownException
 * @package Filanco\Domain\Exception
 */
class OrderStatusUnknownException extends Exception
{
    /**
     * OrderStatusUnknownException constructor.
     * @param string $status
     * @param array $available_statuses
     * @param int $code
     * @param Exception $previous
     */
    public function __construct($status, array $available_statuses, $code = 0, Exception $previous = null)
    {
        $message = 'Неизвестный статус заказа ' . $status . ' известные: ' . implode(', ', $available_statuses);
        parent::__construct($message, $code, $previous);
    }
}
