<?php
namespace Filanco\Domain\Exception;

use Exception;
use Filanco\Domain\Model\BaseModel;

class ValidationFailedException extends Exception
{
    public $key;
    public $name;
    public $value;

    /**
     * ValidationFailedException constructor.
     * @param BaseModel $model
     * @param string $key
     * @param mixed $value
     * @param int $code
     * @param Exception $previous
     */
    public function __construct(BaseModel $model, $key, $value, $code = 0, Exception $previous = null)
    {
        $this->key = $key;
        $this->name = $model->getFieldName($key);
        $this->value = $value;
        $message = 'Значениe ' . $value . ' заполнено не верно для поля ' . $this->name . '!';
        parent::__construct($message, $code, $previous);
    }
}
