<?php
namespace Filanco\Domain\Model;

/**
 * Class ClientIp
 * @package Filanco\Domain\Model
 *
 * @method string getName() Название организации
 * @method string getNameEng() Название организации на англ.
 * @method string getFirstName() Имя
 * @method string getFirstNameEng() Имя контактного лица на англ.
 * @method string getMiddleName() Отчество
 * @method string getMiddleNameEng() Отчество контактного лица на англ.
 * @method string getLastName() Фамилия
 * @method string getLastNameEng() Фамилия контактного лица на англ.
 * @method string getPassportIssueDate() Дата выдачи паспорта
 * @method string getPassportNumber() Серия-номер паспорта
 * @method string getPassportPlace() Место выдачи паспорта
 * @method string getBirthDate() Дата рождения YYYY-MM-DD
 * @method string getJobTitleEng() Должность контактного лица на англ.
 * @method string getOgrnipIssueDate() Дата выдачи ОГРНИП
 * @method string getOgrnip() ОГРНИП
 * @method string getInn() ИНН
 * @method string getBik() БИК
 * @method string getRs() Расчетный счёт
 * @method string getKs() Корреспондентский счет
 * @method string getBank() Наименование банка
 */
class ClientIp extends Client
{
    protected function fields()
    {
        $fields = parent::fields();
        return array_merge($fields, [
            'name' => 'Название организации',
            'name_eng' => 'Название организации на англ.',
            'first_name' => 'Имя контактного лица',
            'first_name_eng' => 'Имя контактного лица на англ.',
            'middle_name' => 'Отчество контактного лица',
            'middle_name_eng' => 'Отчество контактного лица на англ.',
            'last_name_eng' => 'Фамилия контактного лица на англ.',
            'last_name' => 'Фамилия контактного лица',
            'passport_issue_date' => 'Дата выдачи паспорта',
            'passport_number' => 'Серия-номер паспорта',
            'passport_place' => 'Место выдачи паспорта',
            'birth_date' => 'Дата рождения',
            'job_title_eng' => 'Должность контактного лица на англ.',
            'fax' => 'Номер факса',
            'ogrnip_issue_date' => 'Дата выдачи ОГРНИП',
            'ogrnip' => 'ОГРНИП',
            'inn' => 'ИНН',
            'bik' => 'БИК',
            'rs' => 'Расчетный счёт',
            'ks' => 'Корреспондентский счет',
            'bank' => 'Наименование банка',
        ]);
    }

    protected function validators()
    {
        $validators = parent::validators();

        return array_merge($validators, [
            'name' => function ($value) {
                return !empty($value);
            },
            'name_eng' => function ($value) {
                return !empty($value);
            },
            'first_name' => function ($value) {
                return !empty($value);
            },
            'first_name_eng' => function ($value) {
                return !empty($value);
            },
            'middle_name' => function ($value) {
                return !empty($value);
            },
            'middle_name_eng' => function ($value) {
                return !empty($value);
            },
            'last_name' => function ($value) {
                return !empty($value);
            },
            'last_name_eng' => function ($value) {
                return !empty($value);
            },
            'passport_issue_date' => function ($value) {
                return !empty($value);
            },
            'passport_number' => function ($value) {
                return !empty($value);
            },
            'passport_place' => function ($value) {
                return !empty($value);
            },
            'birth_date' => function ($value) {
                return !empty($value);
            },
            'job_title_eng' => function ($value) {
                return !empty($value);
            },
            'fax' => function ($value) {
                $validators = parent::validators();
                return $validators['phone']($value);
            },
            'ogrnip_issue_date' => function ($value) {
                return !empty($value);
            },
            'ogrnip' => function ($value) {
                return !empty($value);
            },
            'inn' => function ($value) {
                return !empty($value);
            },
            'bik' => function ($value) {
                return !empty($value);
            },
            'rs' => function ($value) {
                return !empty($value);
            },
            'ks' => function ($value) {
                return !empty($value);
            },
            'bank' => function ($value) {
                return !empty($value);
            },
        ]);
    }

    public function getFax()
    {
        $phone = sprintf('+%s', preg_replace('/[^0-9]+/ui', '', $this->fields['fax']));
        $this->validate('fax', $phone);
        return $phone;
    }

    public function getPassportData()
    {
        return $this->getPassportNumber() . ' ' . $this->getPassportIssueDate() . ' ' . $this->getPassportPlace();
    }
}