<?php
namespace Filanco\Domain\Model;

/**
 * Class ClientOrg
 * @package Filanco\Domain\Model
 *
 * @method string getOrganizationName() Название организации
 * @method string getOrganizationNameEng() Название организации на англ.
 * @method string getContactFirstNameEng() Название организации на англ.
 * @method string getContactFirstName() Название организации
 * @method string getContactMiddleNameEng() Отчество контактного лица на англ.
 * @method string getContactMiddleName() Отчество контактного лица
 * @method string getContactLastNameEng() Фамилия контактного лица на англ.
 * @method string getContactLastName() Фамилия контактного лица
 * @method string getLegalAddressEng() Юридический адрес на англ.
 * @method string getLegalPerson() ФИО руководителя
 * @method string getLegalPersonEng() ФИО руководителя на англ.
 * @method string getActionUnder() Действует на основании (например: устава)
 * @method string getJobTitleEng() Должность контактного лица на англ.
 * @method string getOgrn() ОГРН
 * @method string getKpp() КПП
 * @method string getInn() ИНН
 */
class ClientOrg extends Client
{
    protected function fields()
    {
        $fields = parent::fields();
        return array_merge($fields, [
            'organization_name' => 'Название организации',
            'organization_name_eng' => 'Название организации на англ.',
            'contact_first_name_eng' => 'Имя контактного лица на англ.',
            'contact_first_name' => 'Имя контактного лица',
            'contact_middle_name_eng' => 'Отчество контактного лица на англ.',
            'contact_middle_name' => 'Отчество контактного лица',
            'contact_last_name_eng' => 'Фамилия контактного лица на англ.',
            'contact_last_name' => 'Фамилия контактного лица',
            'legal_person' => 'ФИО руководителя',
            'legal_person_eng' => 'ФИО руководителя на англ.',
            'action_under' => 'Действует на основании',
            'job_title_eng' => 'Должность контактного лица на англ.',
            'fax' => 'Номер факса',
            'ogrn' => 'ОГРН',
            'kpp' => 'КПП',
            'inn' => 'ИНН',
        ]);
    }

    protected function validators()
    {
        $validators = parent::validators();

        return array_merge($validators, [
            'organization_name' => function ($value) {
                return !empty($value);
            },
            'organization_name_eng' => function ($value) {
                return !empty($value);
            },
            'contact_first_name_eng' => function ($value) {
                return !empty($value);
            },
            'contact_first_name' => function ($value) {
                return !empty($value);
            },
            'contact_middle_name_eng' => function ($value) {
                return !empty($value);
            },
            'contact_middle_name' => function ($value) {
                return !empty($value);
            },
            'contact_last_name_eng' => function ($value) {
                return !empty($value);
            },
            'contact_last_name' => function ($value) {
                return !empty($value);
            },
            'legal_person' => function ($value) {
                return !empty($value);
            },
            'legal_person_eng' => function ($value) {
                return !empty($value);
            },
            'action_under' => function ($value) {
                return !empty($value);
            },
            'job_title_eng' => function ($value) {
                return !empty($value);
            },
            'fax' => function ($value) {
                $validators = parent::validators();
                return $validators['phone']($value);
            },
            'ogrn' => function ($value) {
                return !empty($value);
            },
            'kpp' => function ($value) {
                return !empty($value);
            },
            'inn' => function ($value) {
                return !empty($value);
            },
        ]);
    }

    public function getFax()
    {
        $phone = sprintf('+%s', preg_replace('/[^0-9]+/ui', '', $this->fields['fax']));
        $this->validate('fax', $phone);
        return $phone;
    }
}