<?php
namespace Filanco\Domain\Exception\Manual;

use Exception;
use Filanco\Domain\Exception\ManualResolvingException;

/**
 * Class ExtendedTldParamNotFoundException
 * @package Filanco\Domain\Exception\Manual
 */
class KnownPriceMismatchActualException extends ManualResolvingException
{
    /**
     * KnownPriceMismatchActualException constructor.
     * @param string $domain
     * @param string $known_price
     * @param int $actual
     * @param array $data
     * @param int $code
     * @param Exception|null $previous
     */
    public function __construct($domain, $known_price, $actual, array $data = [], $code = 0, Exception $previous = null)
    {
        $message = 'Актуальная стоимость продления домена ' . $domain . ' - ' . $actual . ' отличается от указанной ' . $known_price . '!';
        parent::__construct($message, $data, $code, $previous);
    }
}
