<?php
namespace Filanco\Domain\Exception;

use Exception;

/**
 * Class GetDomainInfoException
 * @package Filanco\Domain\Exception
 */
class GetDomainInfoException extends ApiException
{
    /**
     * GetDomainInfoException constructor.
     * @param string $domain_name
     * @param string $error
     * @param int $code
     * @param Exception|null $previous
     */
    public function __construct($domain_name, $error, $code = 0, Exception $previous = null)
    {
        $message = 'Не удалось получить информация по домену ' . $domain_name . '(' . $error.  ')';
        parent::__construct($message, $code, $previous);
    }
}
