<?php
namespace Filanco\Domain;

use \Filanco\Domain\Exception\RegistrarApiNotFoundException;

/**
 * Class RegistrarApiFactory
 * @package Filanco\Domain
 */
class RegistrarApiFactory
{
    /**
     * @param RegistrarInterface $registrar
     * @param RegistrarApiLogInterface $logger
     * @param boolean $test
     * @return RegistrarApiAbstract
     * @throws RegistrarApiNotFoundException
     */
    public static function factory(RegistrarInterface $registrar, RegistrarApiLogInterface $logger, $test = false)
    {
        $class_name = __NAMESPACE__ . '\\Api\\' . ucfirst($registrar->getSystemName()) . 'Api';
        if (!class_exists($class_name)) {
            throw new RegistrarApiNotFoundException($class_name);
        }
        return new $class_name($registrar, $logger, $test);
    }
}
