<?php
namespace Filanco\Domain\Model;

/**
 * Class ClientPerson
 * @package Filanco\Domain\Model
 *
 * @method string getName() ФИО
 * @method string getNameEng() ФИО на англ.
 * @method string getFirstName() Имя
 * @method string getFirstNameEng() Имя на англ.
 * @method string getLastName() Фамилия
 * @method string getLastNameEng() Фамилия на англ.
 * @method string getPassportIssueDate() Дата выдачи паспорта
 * @method string getPassportNumber() Серия-номер паспорта
 * @method string getPassportPlace() Место выдачи паспорта
 * @method string getBirthDate() Дата рождения YYYY-MM-DD
 * @method string getInn() ИНН
 */
class ClientPerson extends Client
{
    protected function fields()
    {
        $fields = parent::fields();
        return array_merge($fields, [
            'name' => 'ФИО',
            'name_eng' => 'ФИО на англ.',
            'first_name_eng' => 'Имя на англ.',
            'first_name' => 'Имя',
            'middle_name' => 'Отчество',
            'middle_name_eng' => 'Отчество на англ.',
            'last_name_eng' => 'Фамилия на англ.',
            'last_name' => 'Фамилия',
            'passport_issue_date' => 'Дата выдачи паспорта',
            'passport_number' => 'Серия-номер паспорта',
            'passport_place' => 'Место выдачи паспорта',
            'birth_date' => 'Дата рождения',
            'inn' => 'ИНН',
        ]);
    }

    protected function validators()
    {
        $validators = parent::validators();

        return array_merge($validators, [
            'name' => function ($value) {
                return !empty($value);
            },
            'name_eng' => function ($value) {
                return !empty($value);
            },
            'first_name_eng' => function ($value) {
                return !empty($value);
            },
            'first_name' => function ($value) {
                return !empty($value);
            },
            'middle_name' => function ($value) {
                return !empty($value);
            },
            'middle_name_eng' => function ($value) {
                return !empty($value);
            },
            'last_name_eng' => function ($value) {
                return !empty($value);
            },
            'last_name' => function ($value) {
                return !empty($value);
            },
            'passport_issue_date' => function ($value) {
                return !empty($value);
            },
            'passport_number' => function ($value) {
                return !empty($value);
            },
            'passport_place' => function ($value) {
                return !empty($value);
            },
            'birth_date' => function ($value) {
                return !empty($value);
            },
            'inn' => function ($value) {
                return !empty($value);
            },
        ]);
    }

    public function getPassportData()
    {
        return $this->getPassportNumber() . ' ' . $this->getPassportIssueDate() . ' ' . $this->getPassportPlace();
    }
}