<?php
namespace Filanco\Domain\Model;

/**
 * Class Cost
 * Стоимости действий над доменами
 * @package Filanco\Domain\Model
 * @method float getRegister() Стоимость регистрации домена
 * @method float getRenewal() Стоимость продления домена
 * @method float getRestore() Стоимость восстановления домена
 * @method float getTransfer() Стоимость переноса домена
 * @method float getProtect() Стоимость переноса домена
 */
class Cost extends BaseModel
{
    /**
     * @inheritdoc
     */
    protected function fields()
    {
        return [
            'register' => 'Стоимость регистрации',
            'renewal' => 'Стоимость продления',
            'restore' => 'Стоимость восстановления',
            'transfer' => 'Стоимость переноса',
            'protect' => 'Стоимость скрытия данных',
        ];
    }
}
