<?php
namespace Filanco\Domain\Exception;

use Exception;

/**
 * Class ParseResponseException
 * @package Filanco\Domain\Exception
 */
class ParseResponseException extends Exception
{
    /**
     * ParseResponseException constructor.
     * @param string $message
     * @param int $response
     * @param int $code
     * @param Exception $previous
     */
    public function __construct($message, $response, $code = 0, Exception $previous = null)
    {
        $message = 'Ошибка разбора ответа: ' . $message . PHP_EOL . 'Ответ: ' . json_encode($response);
        parent::__construct($message, $code, $previous);
    }
}
