<?php

namespace Filanco\Domain\Model;

/**
 * Class Registrant
 * @package Filanco\Domain\Model
 *
 * @method string getNicHdl()
 * @method string getType()
 * @method string getIsResident()
 * @method string getEmail()
 * @method string getPhone()
 * @method string getFax()
 * @method string getOrganizationName()
 * @method string getOrganizationNameEng()
 * @method string getName()
 * @method string getNameEng()
 * @method string getFirstName()
 * @method string getMiddleName()
 * @method string getLastName()
 * @method string getPassport()
 * @method string getPassportIssueDate()
 * @method string getPassportNumber()
 * @method string getPassportPlace()
 * @method string getBirthDate()
 * @method string getInn()
 * @method string getOgrnip()
 * @method string getOgrnipIssueDate()
 * @method string getOgrn()
 * @method string getKpp()
 * @method string getRs()
 * @method string getKs()
 * @method string getBik()
 * @method string getBank()
 * @method string getLegalAddress()
 * @method string getPostalAddress()
 * @method string getPostalCode()
 * @method string getCountryCode()
 * @method string getProvince()
 * @method string getCity()
 * @method string getAddress()
 */
class Registrant extends BaseModel
{
    protected function fields()
    {
        return [
            'nic_hdl' => 'Номер регистранта',
            'type' => 'Тип регистранта',
            'is_resident' => 'Резидент ли регистрант',
            'email' => 'Адрес электронной почты',
            'phone' => 'Номер телефона',
            'fax' => 'Номер факса',
            'organization_name' => 'Название организации',
            'organization_name_eng' => 'Название организации на англ.',
            'name' => 'ФИО',
            'name_eng' => 'ФИО на англ.',
            'first_name' => 'Имя',
            'middle_name' => 'Отчество',
            'last_name' => 'Фамилия',
            'passport' => 'Данные паспорта',
            'passport_issue_date' => 'Дата выдачи паспорта',
            'passport_number' => 'Серия-номер паспорта',
            'passport_place' => 'Место выдачи паспорта',
            'birth_date' => 'Дата рождения',
            'inn' => 'ИНН',
            'ogrnip' => 'ОГРНИП',
            'ogrnip_issue_date' => 'Дата выдачи ОГРНИП',
            'ogrn' => 'ОГРН',
            'kpp' => 'КПП',
            'rs' => 'Расчетный счёт',
            'ks' => 'Корреспондентский счет',
            'bik' => 'БИК',
            'bank' => 'Наименование банка',
            'legal_address' => 'Адрес регистрации',
            'postal_address' => 'Почтовый адрес',
            'postal_code' => 'Почтовый индекс',
            'country_code' => 'Двухбуквенный код страны',
            'province' => 'Область',
            'city' => 'Город',
            'address' => 'Адрес без города',
        ];
    }
}