<?php
namespace Filanco\Domain\Exception\Manual;

use Exception;
use Filanco\Domain\Exception\ManualResolvingException;

/**
 * Class ExtendedTldParamNotFoundException
 * @package Filanco\Domain\Exception\Manual
 */
class KnownPriceMismatchActualException extends ManualResolvingException
{
    private $actual_price;

    /**
     * KnownPriceMismatchActualException constructor.
     * @param string $domain
     * @param int|float|string $known_price
     * @param int|float|string $actual
     * @param array $data
     * @param int $code
     * @param Exception|null $previous
     */
    public function __construct($domain, $actual, $known_price, array $data = [], $code = 0, Exception $previous = null)
    {
        $this->actual_price = $actual;
        $message = 'Актуальная стоимость продления домена ' . $domain . ' - ' . $actual . ', отличается от указанной - ' . $known_price . '!';

        parent::__construct($message, $data, $code, $previous);
    }

    public function getActualPrice()
    {
        return $this->actual_price;
    }
}
