<?php
use Filanco\RipnEpp\Client;
use Filanco\RipnEpp\ClientManager;
use Filanco\RipnEpp\Model\Domain;

require_once __DIR__ . '/../vendor/autoload.php';


class DomainFactory
{
    /**
     * @param $domain
     * @return Domain
     */
    public static function getDomain($domain)
    {
        $manager = ClientManager::getInstance();

        $registrars = json_decode(file_get_contents(__DIR__ . '/registry.json'), true);

        foreach ($registrars as $params) {
            $manager->registerClient(new Client($params));
        }

        return new Domain($manager, ['domain_name' => $domain]);
    }
}

var_dump(DomainFactory::getDomain('domenus.ru')->getInfo());


