<?php
namespace Filanco\RipnEpp\Model;

use DOMDocument;
use Filanco\RipnEpp\ClientManager;
use TrueBV\Punycode;

/**
 * Class Domain
 * @package Filanco\RipnEpp\Model
 *
 * @method string getDomainName()
 * @method AuthInfo getAuthInfo()
 */
class Domain extends Api
{
    protected function fields()
    {
        return [
            'domain_name' => 'Доменное имя',
            'auth_info' => 'Авторизационный код',
        ];
    }

    /**
     * Domain constructor.
     * @param ClientManager $client_manager
     * @param $params
     */
    public function __construct(ClientManager $client_manager, $params)
    {
        parent::__construct($client_manager, $params);
        $puny_code = new Punycode();
        $this->fields['domain_name'] = $puny_code->encode($this->fields['domain_name']);
    }

    /**
     * @return DomainInfoResponse
     */
    public function getInfo()
    {
        $document = new DOMDocument('1.0', 'UTF-8');
        $command = $document->createElement('info');
        $domain = $document->createElement('domain:info');
        $domain->setAttribute('xmlns:domain', 'http://www.ripn.net/epp/ripn-domain-1.0');
        $domain->setAttribute('xsi:schemaLocation', 'http://www.ripn.net/epp/ripn-domain-1.0 ripn-domain-1.0.xsd');
        $domain->appendChild($document->createElement('domain:name', $this->getDomainName()));
        $command->appendChild($domain);
        $document->appendChild($command);
        $response = $this->send($command);
        return new DomainInfoResponse($response);
    }

    protected function send($request)
    {
        list(, $tld) = array_pad(explode('.', $this->getDomainName(), 2), 2, null);
        return $this->client_manager->getClient($tld)->send($request);
    }
}
