<?php
namespace Filanco\RipnEpp\Model;

use DOMElement;
use TrueBV\Punycode;

class DomainInfoResponse
{
    /**
     * @var string
     */
    public $name;

    /**
     * @var string
     */
    public $registrant;

    /**
     * @var string
     */
    public $create_date;

    /**
     * @var string
     */
    public $update_date;

    /**
     * @var string
     */
    public $expire_date;

    /**
     * @var string
     */
    public $last_transfer_date;

    /**
     * @var string[]
     */
    public $statuses = [];

    /**
     * DomainInfoResponse constructor.
     * @param DOMElement $response
     */
    public function __construct(DOMElement $response)
    {
        $date_format = 'Y-m-d H:i:s';
        $puny_code = new Punycode();
        $this->name = mb_strtolower($puny_code->decode($response->getElementsByTagName('name')->item(0)->textContent));
        $this->registrant = $response->getElementsByTagName('registrant')->item(0)->textContent;
        $this->create_date = date($date_format, strtotime($response->getElementsByTagName('crDate')->item(0)->textContent));
        $this->expire_date = date($date_format, strtotime($response->getElementsByTagName('exDate')->item(0)->textContent));
        $update_date = $response->getElementsByTagName('upDate');
        if ($update_date->length) {
            $this->update_date = date($date_format, strtotime($update_date->item(0)->textContent));
        }
        $last_transfer = $response->getElementsByTagName('trDate');
        if ($last_transfer->length) {
            $this->last_transfer_date = date($date_format, strtotime($last_transfer->item(0)->textContent));
        }
        $statuses_nodes = $response->getElementsByTagName('status');
        for ($i=0;$i<$statuses_nodes->length; $i++) {
            /** @var DOMElement $status_node */
            $status_node = $statuses_nodes->item(0);
            $this->statuses[] = $status_node->getAttribute('s');
        }
    }
}