<?php
namespace Filanco\RipnEpp\Model;

use DOMDocument;
use Filanco\RipnEpp\ClientManager;
use TrueBV\Punycode;

/**
 * Class Domain
 * @package Filanco\RipnEpp\Model
 *
 * @method string getDomainName()
 * @method AuthInfo getAuthInfo()
 */
class Domain extends Api
{
    const
        STATUS_CLIENT_HOLD = 'clientHold';

    protected function fields()
    {
        return [
            'domain_name' => 'Доменное имя',
            'auth_info' => 'Авторизационный код',
        ];
    }

    /**
     * Domain constructor.
     * @param ClientManager $client_manager
     * @param $params
     */
    public function __construct(ClientManager $client_manager, $params)
    {
        parent::__construct($client_manager, $params);
        $puny_code = new Punycode();
        $this->fields['domain_name'] = $puny_code->encode($this->fields['domain_name']);
    }

    /**
     * @return DomainInfoResponse
     */
    public function getInfo()
    {
        $document = new DOMDocument('1.0', 'UTF-8');
        $command = $document->createElement('info');
        $domain = $document->createElement('domain:info');
        $domain->setAttribute('xmlns:domain', 'http://www.ripn.net/epp/ripn-domain-1.0');
        $domain->setAttribute('xsi:schemaLocation', 'http://www.ripn.net/epp/ripn-domain-1.0 ripn-domain-1.0.xsd');
        $domain->appendChild($document->createElement('domain:name', $this->getDomainName()));
        $auth_info = $this->getAuthInfo();
        if (!empty($auth_info)) {
            $auth_info_node = $document->createElement('domain:authInfo');
            $auth_info_node->appendChild($document->createElement('domain:pw', $auth_info->getPw()));
            $domain->appendChild($auth_info_node);
        }
        $command->appendChild($domain);
        $document->appendChild($command);
        $response = $this->send($command);
        return new DomainInfoResponse($response);
    }

    public function undelegate()
    {
        $document = new DOMDocument('1.0', 'UTF-8');
        $command = $document->createElement('update');
        $domain = $document->createElement('domain:update');
        $domain->setAttribute('xmlns:domain', 'http://www.ripn.net/epp/ripn-domain-1.0');
        $domain->setAttribute('xsi:schemaLocation', 'http://www.ripn.net/epp/ripn-domain-1.0 ripn-domain-1.0.xsd');
        $domain->appendChild($document->createElement('domain:name', $this->getDomainName()));

        $domain_add = $document->createElement('domain:add');
        $status = $document->createElement('domain:status');
        $status->setAttribute('s', self::STATUS_CLIENT_HOLD);
        $domain_add->appendChild($status);
        $domain->appendChild($domain_add);

        $domain_info = $this->getInfo();
        $name_servers = $domain_info->name_servers;
        $domain_remove = $document->createElement('domain:rem');
        $name_servers_node = $document->createElement('domain:ns');
        foreach ($name_servers as $name_server) {
            $name_servers_node->appendChild($document->createElement('domain:hostObj', $name_server));
        }
        $domain_remove->appendChild($name_servers_node);
        $domain->appendChild($domain_remove);

        $command->appendChild($domain);
        $document->appendChild($command);
        $response = $this->send($command);

        return new Response($response);
    }

    /**
     * @param $request
     * @return DOMDocument
     */
    protected function send($request)
    {
        list(, $tld) = array_pad(explode('.', $this->getDomainName(), 2), 2, null);
        return $this->client_manager->getClient($tld)->send($request);
    }
}
